#ifndef SOLVEEQUATION_H
#define SOLVEEQUATION_H


template<class T> 
	/*!
	* \fn void swap_ref (T &a, T &b)
	* Swaps a and b reference.
	* \param a - first reference.
	* \param b - second reference.
	*/
void swap_ref (T &a, T &b) {
	T c;
	c = a;
	a = b;
	b = c;
}

template<class T> 

	 /*!
	* \fn void swap_ptr (T *a, T *b)
	* Swaps a and b pointer.
	* \param a - first pointer.
	* \param b - second pointer.
	*/
void swap_ptr (T *a, T *b) {
	if (a==0 || b==0) return;
	T c;
	c = *a;
	*a = *b;
	*b = c;
}

	/*!
	* \fn bool solve (double a, double b, double c, double &x1, double &x2)
	* For solving a quadratic equation (ax^2 + bx + c = 0)
	* \param a - a
	* \param b - b 
	* \param c - c
	* \param x1 - reference to x^2
	* \param x2 - reference to x
	* \return true - equation is solvable, false -  equation has no solution in real numbers.
	*/
bool solve (double a, double b, double c, double &x1, double &x2);

#endif
