#ifndef MYARRAY_H
#define MYARRAY_H

/*!
* \class MyArray
* \brief Class for creating a dynamic array.
*/
template <class T>
class MyArray {

public:

	/// Pointer to the content of the array.
	T *content;
	
	/// Contructor for creating an array with default parameters
	MyArray () {
		content = 0;
		size = 0;
	}

	/*!
	* Copyconstructor
	* \param a - object witch will be copied.
	* \return the object of the copied class.
	*/
	MyArray (const MyArray& a) {
		content = a.content;
		size = a.getSize();
	}

	/*!
	* Overload assignment-operator
	* \param array - array witch will be copied.
	* \return the object of the copied class.
	*/
	MyArray& operator= (const MyArray& a);
	

	/// Destructor
	~MyArray () {
		delete[] content;
	}

	/*!
	* \fn unsigned int getSize () const
	* For geting the size of the array.
	* \return size of the array.
	*/
	unsigned int getSize () const {
		return size;
	}

	/*!
	* \fn void addElement (T element)
	* Function for adding elemts to the array.
	* \param element - elemet to be added.
	*/
	void addElement (T element) {
		if (content==0) {
			content = new T [size+1];
			content[0] = element;
			size++;
		}
		else {
			T *oldContent = new T [size];
			
			for (unsigned int i = 0; i < size; i++) {
				oldContent[i] = content[i];
			}
			
			content = new T [size+1];
			
			for (unsigned int i = 0; i < size; i++) {
				content[i] = oldContent[i];
			}
			
			content[size] = element;
			size++;
			delete[] oldContent;
		}
	}
	

	/*!
	* \fn T& operator[] (unsigned int i)
	* Operator [] returns the i-element of the array.
	* \param i - the place of the element.
	* \return the seleced element.
	*/
	T& operator[] (unsigned int i);
	
private:
	/// Size of the array.
	unsigned int size;
};

template <class T>
MyArray<T>& MyArray<T>::operator= (const MyArray<T>& a) {
	//check for self-assignment
	if (this == &a) 
	  return *this;
	//copy array content
	content = a.content;
	//copy array size
	size = a.getSize();
	//return the existing array
	return *this;
}

template <class T>
T& MyArray<T>::operator[] (unsigned int i) {
	return content[i];
}
#endif
