#ifndef DEMOHELPER_H
#define DEMOHELPER_H

#include "allegro.h"
#include <string>
#include <vector>
#include "viies.h"
/*!
* \class DemoHelper
* \brief Contains all the needed functions for the demoapp
*/
using namespace std;

/*!
* \fn drawPoints()
* Draws all created points from points vector.
*/
void drawPoints();
/*!
* \fn drawLines()
* Draws all created lines from lines vector.
*/
void drawLines();
/*!
* \fn makePoint(int x, int y)
* Creates Vector2 point.
* \param x - x coordinate.
* \param y - y coordinate.
*/
void makePoint(int x, int y);
/*!
* \fn makeLine(int x, int y)
* Creates Line from two Vector2 points.
* \param x - First Vector2 point location in points vector.
* \param y - Second Vector2 point location in points vector.
*/
void makeLine(int x, int y);
/*!
* \fn getPointsCount()
* gets all created points count.
* \return points count.
*/
int getPointsCount();
/*!
* \fn getLinesCount()
* Gets all created lines count.
* \return lines count.
*/
int getLinesCount();
/*!
* \fn getPointPos(int x, int y)
* Gets given point with given coordinates positsion in points vector.
* \param x - x coordinate.
* \param y - y coordinate.
* \return point positsion in points vector or -1 if with given coordinates isn't any points.
*/
int getPointPos(int x, int y);
/*!
* \fn getLinePos(int x, int y)
* Gets line from given coordinates positsion.
* \param x - x coordinate.
* \param y - y coordinate.
* \return line positsion in lines vector or -1 if with given coordinates isn't any lines.
*/
int getLinePos(int x, int y);
/*!
* \fn changePositsion(int i, int x, int y)
* Changes point coordinates.
* \param i - point positsion in points vector.
* \param x - new x coordinate.
* \param y - new y coordinate.
*/
void changePositsion(int i, int x, int y);
/*!
* \fn deletePoint(int pointPos)
* Deletes point by its positsion in points vector.
* \param pointPos - point positsion in points vector.
*/
void deletePoint(int pointPos);
/*!
* \fn deleteLinesByPoint(int pointPos)
* Deletes Lines if they contain point with given point positsion.
* \param pointPos - point positsion in points vector..
*/
void deleteLinesByPoint(int pointPos);
/*!
* \fn moveLinesPointsFront(int pointPOos)
* Moves all lines points references one step front if they are placed in points vector after given positsion.
* \param pointPos - point positsion in points vector.
*/
void moveLinesPointsFront(int pointPos);
/*!
* \fn deleteLine(int linePos)
* Deletes line with given positsion in lines vector.
* \param linePos - line positsion in lines vector.
*/
void deleteLine(int linePos);
#endif // DEMOHELPER_H
