#include "allegro.h"
#include "DemoHelper.h"
#include <cstdlib>
#include <iostream>
using namespace std;

int main (int argc, char* argv[]) {

	// Initialize the Allegro library	
	if (allegro_init () != 0) {
		allegro_message ("Error initializing the Allegro library!");
		return EXIT_FAILURE;
	}
	// Set up Allegro functions
	install_keyboard ();
	install_timer ();
	install_mouse ();

	// Set a windowed graphics mode, 800x600 windowed, 32-bit color depth
	set_color_depth (desktop_color_depth ());
	if (set_gfx_mode (GFX_AUTODETECT_WINDOWED, 800, 600, 0, 0) != 0) {
		allegro_message ("Error creating 800x600x32 window!");
		return EXIT_FAILURE;
	}
	// Wait until the user presses a key and then quit
	int point_x = 100, point_y = 100;
	bool draw_screen=true;
	bool running=true;
	bool mousePressed=false;
	int choice=0;
	int pointsCount=0;
	int linesCount=0;
	int pointOnePos=-1;
	int pointTwoPos=-1;
	int positsion=-1;
	const char* text="Vali tegevus";
	const char* textLine="Vali esimene tipp";
	char counter[19]="Punkte: ";
	//A=1, M=2, D=3, L=4, X=5
	show_mouse(screen);
	while (running){
		if (draw_screen) {
			/* Clear the screen to red. */
			switch (choice) {
			case 1:
				text="Tippude lisamine";
				if (mousePressed) {
					mousePressed=false;
					if (getPointPos(point_x, point_y)==-1) {
					makePoint(point_x,point_y);
					pointsCount=getPointsCount();}
				}
				break;
			case 2:
				text="Tipu liigutamine";
				if (mousePressed) {
					 mousePressed=false;
					 positsion=getPointPos(point_x,point_y);
					if (positsion!=-1){
						while(mouse_b & 1) {
							if (getPointPos(mouse_x, mouse_y)==-1) {
								changePositsion(positsion, mouse_x, mouse_y);
							 clear_to_color(screen, makecol(255, 255, 255));
							 drawPoints();
							 drawLines();
							 			textout_ex(screen, font, "A - lisa tipp", 5, 5, makecol(0, 0, 0), -1);
										textout_ex(screen, font, "M - liiguta tippu", 5, 15, makecol(0, 0, 0), -1);
										textout_ex(screen, font, "D - kustuta tipp", 5, 25, makecol(0, 0, 0), -1);
										textout_ex(screen, font, "L - lisa joon", 5, 35, makecol(0, 0, 0), -1);
										textout_ex(screen, font, "X - kustuta joon", 5, 45, makecol(0, 0, 0), -1);
										textout_ex(screen, font, "ESC - sulge programm", 5, 55, makecol(0, 0, 0), -1);
										textout_ex(screen, font, text, 600, 10, makecol(0, 0, 0), -1);
										sprintf( counter,"Punkte: %d", pointsCount);
										textout_ex(screen, font, counter, 5, 575, makecol(0, 0, 0), -1);
										sprintf( counter," Jooni: %d", linesCount);
										textout_ex(screen, font, counter, 110, 575, makecol(0, 0, 0), -1);
							rest(40);
							}
						}
					}
				}
				break;
			case 3:
				text="Tipu kustutamine";
				if (mousePressed) {
					mousePressed=false;
					positsion=getPointPos(point_x, point_y);
					if (positsion>-1) {
						deletePoint(positsion);
						pointsCount=getPointsCount();
					linesCount=getLinesCount();
						if (pointsCount==0) {
							text="Vali tegevus";
							choice=0;
						}
					}
				}
				break;
			case 4:
				text="Joone lisamine";
				if (mousePressed) {
					mousePressed=false;
					if (pointOnePos==-1) {
						pointOnePos=getPointPos(point_x, point_y);
						if (pointOnePos>-1) {
							textLine="Vali teine tipp";
						}
					} else {
						pointTwoPos=getPointPos(point_x, point_y);
						if (pointTwoPos>-1 & pointTwoPos!=pointOnePos) {
							makeLine(pointOnePos, pointTwoPos);
							pointOnePos=-1;
							pointTwoPos=-1;
							linesCount=getLinesCount();
							textLine="Vali esimene tipp";
						rest(250);
						}
					}
				}
				break;
			case 5:
				text="Joone kustutamine";
					if (mousePressed) {
						mousePressed=false;
						positsion=getLinePos(point_x, point_y);
						if (positsion>-1) {
							deleteLine(positsion);
							linesCount=getLinesCount();
							if (linesCount==0) {
								text="Vali tegevus";
								choice=0;
							}
						 }
					}
				break;
			default:

				break;
			}
			clear_to_color(screen, makecol(255, 255, 255));
			drawPoints();
			drawLines();
			textout_ex(screen, font, "A - lisa tipp", 5, 5, makecol(0, 0, 0), -1);
			textout_ex(screen, font, "M - liiguta tippu", 5, 15, makecol(0, 0, 0), -1);
			textout_ex(screen, font, "D - kustuta tipp", 5, 25, makecol(0, 0, 0), -1);
			textout_ex(screen, font, "L - lisa joon", 5, 35, makecol(0, 0, 0), -1);
			textout_ex(screen, font, "X - kustuta joon", 5, 45, makecol(0, 0, 0), -1);
			textout_ex(screen, font, "ESC - sulge programm", 5, 55, makecol(0, 0, 0), -1);
			textout_ex(screen, font, text, 600, 10, makecol(0, 0, 0), -1);
			if (choice==4) textout_ex(screen, font, textLine, 600, 20, makecol(0, 0, 0), -1);
			sprintf( counter,"Punkte: %d", pointsCount);
			textout_ex(screen, font, counter, 5, 575, makecol(0, 0, 0), -1);
			sprintf( counter," Jooni: %d", linesCount);
			textout_ex(screen, font, counter, 110, 575, makecol(0, 0, 0), -1);
			draw_screen=false;
		}
		rest(40);
		if (choice!=0 & mouse_b & 1) {
			point_x= mouse_x;
			point_y= mouse_y;
			mousePressed=true;
			draw_screen=true;
		}
		if (key[KEY_A]){
			choice=1;
			draw_screen=true;
		}
		if (key[KEY_M] & getPointsCount()>0){
			choice=2;
			draw_screen=true;
		}
		if (key[KEY_D] & getPointsCount>0){
			choice=3;
			draw_screen=true;
		}
		if (key[KEY_L] & getPointsCount()>1){
			choice=4;
			draw_screen=true;
		}
		if (key[KEY_X] & getLinesCount>0){
			choice=5;
			draw_screen=true;
		}
		if (key[KEY_ESC]){
			running=false;
		}
	}
	return EXIT_SUCCESS;
}

// NB! This is required for Allegro to maintain platform compatibility
END_OF_MAIN()
