#include "DemoHelper.h"
#include <iostream>
#include <cmath>

vector<Vector2> points;
vector< DynamicLine<Vector2> > lines;
DynamicLine<Vector2> l;

void drawPoints() {
for (int i=0; i<(int)points.size(); i++) {
circle(screen, points[i].x, points[i].y, 2.5, makecol(0,0,0));
	  }
}

void drawLines() {
for (int i=0; i<(int)lines.size();i++) {
line(screen, (*lines[i].p1).x, (*lines[i].p1).y, (*lines[i].p2).x, (*lines[i].p2).y, makecol(0,0,0));
	}
}

void makePoint(int x, int y) {
Vector2 v(x,y);
points.push_back(v);
}

int getPointPos(int x,int y){
	for (int i=0; i<(int)points.size();i++){
		if ((points[i].x>(x-5) & points[i].x<(x+5)) & (points[i].y>(y-5) & points[i].y<(y+5))) return i;
	}
	return -1;
}

void makeLine(int pointOnePos, int pointTwoPos) {
DynamicLine<Vector2> l (&points[pointOnePos],&points[pointTwoPos]);
lines.push_back(l);
}

int getPointsCount(){
	return points.size();
}

int getLinesCount(){
	return lines.size();
}
void changePositsion(int i, int x, int y){
	points[i].x=x;
	points[i].y=y;
}

int getLinePos(int x, int y){
	int xu, yu, xv, yv;
	for (int i=0; i<(int)lines.size();i++){
		xu=x-(*lines[i].p1).x;
		yu=y-(*lines[i].p1).y;
		xv=(*lines[i].p2).x-(*lines[i].p1).x;
		yv=(*lines[i].p2).y-(*lines[i].p1).y;
		if (xu*xv+yu*yv<0) {
			if (sqrt(pow(x-(*lines[i].p1).x,2)+pow(y-(*lines[i].p1).y,2))<=1) return i;
		} else {
			xu=x-(*lines[i].p2).x;
			yu=y-(*lines[i].p2).y;
			xv=-xv;
			yv=-yv;
			if (xu*xv+yu*yv<0) {
				if (sqrt(pow(x-(*lines[i].p2).x,2)+pow(y-(*lines[i].p2).y,2))<=1) return i;
			} else {
				if (abs((x*((*lines[i].p1).y-(*lines[i].p2).y)+y*((*lines[i].p2).x-(*lines[i].p1).x) +((*lines[i].p1).x*(*lines[i].p2).y-(*lines[i].p2).x*(*lines[i].p1).y))/sqrt(pow((*lines[i].p2).x-(*lines[i].p1).x,2)+pow((*lines[i].p1).y-(*lines[i].p2).y,2)))<=1) return i;
			}
		}
	}
	return -1;
}

void deletePoint(int pointPos){
deleteLinesByPoint(pointPos);
moveLinesPointsFront(pointPos);
points.erase(points.begin()+pointPos);
}

void deleteLinesByPoint(int pointPos){
int endVector=lines.size()-1;
	for (int i=endVector;i>=0;i--) {
		if (((*lines[i].p1).x==points[pointPos].x & (*lines[i].p1).y==points[pointPos].y) || ((*lines[i].p2).x==points[pointPos].x & (*lines[i].p2).y==points[pointPos].y) ) deleteLine(i);
	}
}

  void moveLinesPointsFront(int pointPos){
	int positsion;
	for (int i=0; i<(int)lines.size(); i++) {
		positsion=getPointPos((*lines[i].p1).x,(*lines[i].p1).y);
		if (positsion>pointPos) {
			lines[i].p1=&points[positsion-1];
		}
		positsion=getPointPos((*lines[i].p2).x,(*lines[i].p2).y);
		if (positsion>pointPos) {
			lines[i].p2=&points[positsion-1];
		}
	}
}

void deleteLine(int linePos) {
lines.erase(lines.begin()+linePos);
}
