#ifndef DEMOHELPER_H
#define DEMOHELPER_H

#include "methods.h"
/*!
* \class DemoHelper
* \brief Contains functions for writing text.
*/
using namespace std;
/*!
* \fn drawText(const char* rightCorner, int pointCounter, int lineCounter, const char* line)
* Draws all texts to the screen.
* \param rightCorner - text what will be written upper right corner.
* \param pointCounter - text what will be written as many points is created.
* \param lineCounter - text what will be written as many lines is created.
* \param line - text what will be written if rightCorner text down.
*/
void drawText(const char* rightCorner,int pointCounter,int lineCounter,const char* line);
/*!
* \fn pointCountToCharArray(int number)
* returns given number as char array as point counter.
* \param number - points count.
* \return char array.
*/
char* pointCountToCharArray(int number);
/*!
* \fn lineCountToCharArray(int number)
* returns given number as char array as line counter.
* \param number - lines count.
* \return char array.
*/
char* lineCountToCharArray( int number);
#endif // DEMOHELPER_H
