#ifndef DYNAMICLINE_H
#define DYNAMICLINE_H

/*!
* \class DynamicLine
* \brief Class for creating a line.
*/
template<class T>
class DynamicLine {

public:

	/// Start point of the line.
	T* p1;
	/// End point of the line.
	T* p2;

	/// Contructor for creating a line with default parameters.
	DynamicLine () {
		p1 = 0;
		p2 = 0;
	}

	/*!
	* Contructor for creating a line with given parameters.
	* \param v1 - start point.
	* \param v2 - end point.
	*/
	DynamicLine (T *v1, T *v2) {
		p1 = v1;
		p2 = v2;
	}
	
	/*!
	* Copyconstructor
	* \param l - object witch will be copied.
	* \return the object of the copied class.
	*/
	DynamicLine (const DynamicLine& l) {
		p1 = l.p1;
		p2 = l.p2;
	}


	
	/*!
	* Overload assignment-operator
	* \param l - object witch will be copied.
	* \return the object of the copied class.
	*/
	 DynamicLine& operator= (const DynamicLine& l);

	/// Destructor
	~DynamicLine () {
	}

};

template <class T>
DynamicLine<T>& DynamicLine<T>::operator= (const DynamicLine<T>& l) {
	//check for self-assignment
	if (this == &l) 
	  return *this;
	//copy the lines
	p1 = l.p1;
	p2 = l.p2;
	//return the existing lines
	return *this;
}
#endif // DYNAMICLINE_H
