#ifndef MAPS_H
#define MAPS_H
/*!
* \class Maps
* \brief Contains lines and points maps and functions.
*/
/*!
* \fn drawPoints()
* draws all points from point map.
*/
void drawPoints();
/*!
* \fn creatPoint(int x, int y)
* creates point if there isn't any in 5 pixel radio.
* \param x - x coordinate.
* \param y - y coordinate.
*/
void createPoint(int x, int y);
/*!
* \fn getPointsSize()
* returns points count in point map.
* \return points count.
*/
int getPointsSize();
/*!
* \fn getPointKey(int x, int y)
* return points key in the map with given coordinates. 
* \param x - x coordinate.
* \param y - y coordinate.
* \return points key value in the map or -1 if in the map wasn't point with given coordinates.
*/
int getPointKey(int x, int y);
/*!
* \fn movePoint(int x, int y, int key)
* change given key value point coordinates with given ones.
* \param x - new x coordinate.
* \param y - new y coordinate.
*/
void movePoint(int x, int y, int key);
/*!
* \fn erasePoint(int x, int y)
* remoces point of given coordinates from map.
* \param x - x coordinate.
* \param y - y coordinate.
*/
void erasePoint(int x, int y);
/*!
* \fn drawLines()
* draws all lines from map to the screen.
*/
void drawLines();
/*!
* \fn createLine(int key1, int key2)
* creates line between two points.
* \param key1 - first point key.
* \param key2 - second point key.
*/
void createLine(int key1, int key2);
/*!
* \fn getLinesSize()
* returns size of lines map.
* \return lines count.
*/
int getLinesSize();
/*!
* \fn eraseLine(int x, int y)
* erase line with given coordinates.
* \param x - x coordinate.
* \param y - y coordinate.
*/
void eraseLine(int x, int y);
/*!
* \fn getLineKey(int x, int y)
* returns lines key in the map if given coordinates is on the line
* \param x - x coordinate.
* \param y - y coordinate.
* \return lines key int the map or -1, if coordinates wasn't in the line.
*/
int getLineKey(int x, int y);
/*!
* \fn eraseLines(int pointKey)
* removes all lines from the map what contains point of given key in the points map.
* \param pointKey - point key in the map.
*/
void eraseLines(int pointKey);
#endif // MAPS_H
