#include "methods.h"
#include <cstdlib>
#include <iostream>
using namespace std;

int main (int argc, char* argv[]) {

	// Initialize the Allegro library	
	if (allegro_init () != 0) {
		allegro_message ("Error initializing the Allegro library!");
		return EXIT_FAILURE;
	}
	// Set up Allegro functions
	install_keyboard ();
	install_timer ();
	install_mouse ();
	// Set a windowed graphics mode, 800x600 windowed, 32-bit color depth
	set_color_depth (desktop_color_depth ());
	if (set_gfx_mode (GFX_AUTODETECT_WINDOWED, 800, 600, 0, 0) != 0) {
		allegro_message ("Error creating 800x600x32 window!");
		return EXIT_FAILURE;
	}
	int point_x, point_y;
	bool draw_screen=true;
	bool running=true;
	bool coordsChanged=false;	drawPoints();
	drawLines();
	unsigned int pressedKey=0;
	unsigned int lines=0, points=0;
	const char* rightCorner="";
	const char* line="";
	int pointKey;
	int lineFirstPointKey=-1;
	show_mouse(screen);
	// Wait until the user presses a esc key and then quit
	while (running){
		rest(25);
		if (draw_screen) {
			switch (pressedKey) {
			case 1:
				rightCorner="Tippude lisamine";
				if (coordsChanged) {
					coordsChanged=false;
					createPoint(point_x, point_y);
					points=getPointsSize();
				}
				break;
			case 2:
				rightCorner="Tipu liigutamine";
				if (coordsChanged) {
					coordsChanged=false;
					pointKey=getPointKey(point_x, point_y);
					if (pointKey>-1) {
						while (mouse_b & 1) {
							if (getPointKey(mouse_x, mouse_y)==-1) {
								movePoint(mouse_x, mouse_y, pointKey);
								drawText(rightCorner, points, lines, line);
								drawPoints();
								drawLines();
								rest(25);
							}
						}
					}
				}
				break;
			case 3:
				rightCorner="Tipu kustutamine";
				if (coordsChanged) {
					coordsChanged=false;
					erasePoint(point_x, point_y);
					points=getPointsSize();
					lines=getLinesSize();
				}
				if (points==0) {
					pressedKey=0;
					rightCorner="";
				}
				break;
			case 4: 
				rightCorner="Joone lisamine";
				if (lineFirstPointKey==-1) {
				line="Vali esimene tipp";
				} else {
				line="Vali teine tipp";
				}
				if (coordsChanged) {
					coordsChanged=false;
					pointKey=getPointKey(point_x, point_y);
					if (pointKey>-1) {
						if (lineFirstPointKey==-1) {
							lineFirstPointKey=pointKey;
						} else {
							 if (pointKey!=lineFirstPointKey){
								createLine(lineFirstPointKey, pointKey);
								lines=getLinesSize();
								lineFirstPointKey=-1;
								line="Vali esimene tipp";
								rest (300);
							}
						}
					}
				}
				break;
			case 5:
				rightCorner="Joone kustutamine";
				if (coordsChanged) {
					coordsChanged=false;
					eraseLine(point_x, point_y);
					lines=getLinesSize();
				}
				if (lines==0) {
					pressedKey=0;
					rightCorner="";
				}
				break;
			default:
				break;
			}
			drawText(rightCorner, points, lines,line);
			drawPoints();
			drawLines();
			draw_screen=false;
		}
		if (key[KEY_A]){
			pressedKey=1;
			draw_screen=true;
			lineFirstPointKey=-1;
			line="";
		}
		if (key[KEY_M] & points>0){
			pressedKey=2;
			draw_screen=true;
			lineFirstPointKey=-1;
			line="";
		}
		if (key[KEY_D] & points>0){
			pressedKey=3;
			draw_screen=true;
			lineFirstPointKey=-1;
			line="";
		}
		if (key[KEY_L] & points>1){
			pressedKey=4;
			draw_screen=true;
			lineFirstPointKey=-1;
		}
		if (key[KEY_X] & lines>0){
			pressedKey=5;
			draw_screen=true;
			lineFirstPointKey=-1;
			line="";
		}
		if (key[KEY_ESC]){
			running=false;
		}
		if (mouse_b & 1 & pressedKey!=0) {
			point_x= mouse_x;
			point_y= mouse_y;
			coordsChanged=true;
			draw_screen=true;
		}
	}
	return EXIT_SUCCESS;
}

// NB! This is required for Allegro to maintain platform compatibility
END_OF_MAIN()
