#include "methods.h"
#include <map>
#include <cmath>
using namespace std;

int pointID=0;
map<int, Vector2> points;

int lineID=0;
map<int, DynamicLine<Vector2> > lines;

void drawPoints(){
	Vector2 v;
	map<int, Vector2>::const_iterator iter;
	for( iter = points.begin(); iter != points.end(); ++iter ) {
		v=iter->second;
		circle(screen, v.x, v.y, 2.5, makecol(0,0,0));
	}
}
void createPoint(int x, int y){
	if (getPointKey(x,y)==-1) {
		Vector2 v(x,y);
		points[pointID++]=v;
	}
}
int getPointsSize(){
	return points.size();
}
int getPointKey(int x, int y){
	Vector2 v;
	map<int, Vector2>::const_iterator iter;
	for( iter = points.begin(); iter != points.end(); ++iter ) {
		v=iter->second;
		if ((v.x>(x-5) & v.x<(x+5)) & (v.y>(y-5) & v.y<(y+5))) return iter->first;
	}
	return -1;
}
void movePoint(int x, int y, int key){
	points[key].x=x;
	points[key].y=y;
}
void erasePoint(int x, int y){
	int key=getPointKey(x, y);
	if (key!=-1)
		eraseLines(key);
		points.erase(key);	
}

void eraseLines(int pointKey){
	DynamicLine<Vector2> l;
	Vector2 p1;
	Vector2 p2;
	map<int, DynamicLine<Vector2> >::const_iterator iter;
	for( iter = lines.begin(); iter != lines.end(); iter++) {
		l=iter->second;
		p1=*l.p1;
		p2=*l.p2;
		if (p1.x==points[pointKey].x & p1.y==points[pointKey].y) lines.erase(iter->first);
		if (p2.x==points[pointKey].x & p2.y==points[pointKey].y) lines.erase(iter->first); 
	}

}
void drawLines(){
DynamicLine<Vector2> l;
map<int, DynamicLine<Vector2> >::const_iterator iter;
for( iter = lines.begin(); iter != lines.end(); ++iter ) {
	l=iter->second;
	line(screen, (*l.p1).x, (*l.p1).y, (*l.p2).x, (*l.p2).y, makecol(0,0,0));
}
}
void createLine(int key1, int key2){
DynamicLine<Vector2> l (&points[key1], &points[key2]);
lines[lineID++]=l;
}
int getLinesSize(){
return lines.size();
}
void eraseLine(int x, int y) {
	int key=getLineKey(x, y);
	if (key!=-1) {
		lines.erase(key);
	}
}
int getLineKey(int x,int y){
	DynamicLine<Vector2> l;
	Vector2 p1;
	Vector2 p2;
	map<int, DynamicLine<Vector2> >::const_iterator iter;
	int xu, yu, xv, yv;
	for( iter = lines.begin(); iter != lines.end(); ++iter ) {
		l=iter->second;
		p1=*l.p1;
		p2=*l.p2;
		xu=x-p1.x;
		yu=y-p1.y;
		xv=p2.x-p1.x;
		yv=p2.y-p1.y;
		if (xu*xv+yu*yv<0) {
			if (sqrt(pow(x-p1.x,2)+pow(y-p1.y,2))<=1) return iter->first;
		} else {
			xu=x-p2.x;
			yu=y-p2.y;
			xv=-xv;
			yv=-yv;
			if (xu*xv+yu*yv<0) {
				if (sqrt(pow(x-p2.x,2)+pow(y-p2.y,2))<=1) return iter->first;
			} else {
				if (abs((x*(p1.y-p2.y)+y*(p2.x-p1.x) +(p1.x*p2.y-p2.x*p1.y))/sqrt(pow(p2.x-p1.x,2)+pow(p1.y-p2.y,2)))<=1) return iter->first;
			}
		}
	}
	return -1;
}

