CREATE TABLE mina (
    eesnimi varchar(30) not null,
    perenimi varchar(100) not null,
    sugu varchar(5) not null,
    synnipaev date not null,
    algus datetime not null default current timestamp,
    viimati datetime default timestamp,
    CONSTRAINT pk_mina PRIMARY KEY(eesnimi)
);
GRANT CONNECT TO Signe IDENTIFIED BY 'Signe';
GRANT DELETE ON mina TO Signe;
GRANT INSERT ON mina TO Signe;
REVOKE INSERT ON mina FROM Signe;
GRANT GROUP TO Signe;
REVOKE GROUP FROM Signe;
REVOKE CONNECT FROM Signe;
CREATE GLOBAL TEMPORARY TABLE paha (
nimi VARCHAR(40) NOT NULL,
CONSTRAINT pk_paha PRIMARY KEY(nimi)
) ON COMMIT PRESERVE ROWS;
CREATE TABLE isik (
id INTEGER NOT NULL DEFAULT AUTOINCREMENT PRIMARY KEY,
eesnimi VARCHAR(50) NOT NULL,
perenimi VARCHAR(50) NOT NULL,
isikukood VARCHAR(11),
klubi INTEGER,
UNIQUE ( eesnimi, perenimi )
);
CREATE TABLE klubi (
ID INTEGER NOT NULL DEFAULT AUTOINCREMENT PRIMARY KEY,
nimi VARCHAR(100) NOT NULL UNIQUE
);
CREATE TABLE turniir (
id INTEGER NOT NULL DEFAULT AUTOINCREMENT PRIMARY KEY,
nimetus VARCHAR(100) NOT NULL UNIQUE,
toimumiskoht VARCHAR(100),
alguskuupaev DATE NOT NULL,
loppkuupaev DATE
);
CREATE TABLE partii (
id INTEGER NOT NULL DEFAULT AUTOINCREMENT PRIMARY KEY,
turniir INTEGER NOT NULL,
algushetk DATETIME NOT NULL DEFAULT CURRENT TIMESTAMP,
lopphetk DATETIME,
valge INTEGER NOT NULL,
must INTEGER NOT NULL,
valge_tulemus SMALLINT CHECK (valge_tulemus IN (0,1,2)),
musta_tulemus SMALLINT CHECK (musta_tulemus IN (0,1,2)),
kokkuvote VARCHAR(5000)
);
INPUT INTO klubi FROM C FORMAT ASCII DELIMITED BY '\x09';
INPUT INTO isik FROM C FORMAT ASCII DELIMITED BY '\x09' (id, eesnimi, perenimi, klubi);
ALTER TABLE turniir RENAME nimetus TO nimi;
ALTER TABLE isik DROP UNIQUE (eesnimi,perenimi);
ALTER TABLE isik ADD CONSTRAINT un_nimi UNIQUE(eesnimi,perenimi);
ALTER TABLE klubi ADD aadress VARCHAR(50) NOT NULL DEFAULT 'Tartu';
ALTER TABLE turniir ADD CONSTRAINT un_nimi UNIQUE(nimi);
ALTER TABLE klubi MODIFY aadress VARCHAR(60);
ALTER TABLE klubi ADD aadress70 VARCHAR(80) NOT NULL DEFAULT 'Tartu';
UPDATE klubi SET aadress70 = aadress;
ALTER TABLE klubi DROP aadress;
ALTER TABLE klubi RENAME aadress70 TO aadress;
ALTER TABLE isik ADD CONSTRAINT fk_isik_2_klubi FOREIGN KEY (klubi) REFERENCES klubi(id) ON DELETE RESTRICT ON UPDATE CASCADE;
ALTER TABLE partii ADD CONSTRAINT fk_partii_2_turniir FOREIGN KEY (turniir) REFERENCES turniir(id) ON DELETE CASCADE ON UPDATE CASCADE;
ALTER TABLE partii ADD CONSTRAINT fk_partii_2_isik_valge FOREIGN KEY (valge) REFERENCES isik(id) ON DELETE RESTRICT ON UPDATE CASCADE;
ALTER TABLE partii ADD CONSTRAINT fk_partii_2_isik_must FOREIGN KEY (must) REFERENCES isik(id) ON DELETE RESTRICT ON UPDATE CASCADE;
INPUT INTO turniir FROM C FORMAT ASCII DELIMITED BY '\x09';
INPUT INTO partii FROM C FORMAT ASCII DELIMITED BY '\x09' (turniir,algushetk,lopphetk,valge,must,valge_tulemus,musta_tulemus);
SELECT isik.eesnimi,isik.perenimi FROM isik JOIN klubi ON isik.klubi=klubi.id WHERE klubi.nimi = 'Laudnikud' ORDER BY isik.eesnimi ASC, isik.perenimi ASC;
SELECT COUNT(*) FROM isik JOIN klubi ON isik.klubi=klubi.id WHERE klubi.nimi = 'Laudnikud';
SELECT isik.perenimi FROM isik JOIN klubi ON isik.klubi=klubi.id WHERE klubi.nimi LIKE 'V%' AND isik.eesnimi LIKE 'M%';
SELECT MIN(algushetk) FROM partii;
SELECT valge.*,must.* FROM partii INNER JOIN isik AS valge ON partii.valge=valge.id INNER JOIN isik AS must ON partii.must=must.id WHERE MONTH(partii.algushetk) = '03' AND HOUR(partii.algushetk) BETWEEN '09' AND '10';
SELECT isik.eesnimi,isik.perenimi FROM partii JOIN isik ON partii.valge=isik.id WHERE partii.valge_tulemus=2;
SELECT isik.perenimi FROM isik GROUP BY isik.perenimi HAVING count(*)>1;
SELECT klubi.nimi FROM klubi KEY JOIN isik GROUP BY klubi.nimi HAVING count(*)<4;
SELECT COUNT(*) FROM partii JOIN isik ON partii.must=isik.id WHERE isik.eesnimi = 'Arvo';
SELECT turniir.nimi, COUNT(*) FROM partii JOIN isik ON partii.must=isik.id JOIN turniir ON partii.turniir=turniir.id WHERE isik.eesnimi = 'Arvo' GROUP BY turniir.nimi;
SELECT sum(CASE partii.valge_tulemus 
                WHEN 2 THEN 1
                WHEN 1 THEN 0.5
            END) AS Punktid FROM partii JOIN isik ON partii.valge=isik.id WHERE isik.eesnimi = 'Maria';
SELECT turniir.nimi, AVG(DATEDIFF(minute,partii.algushetk,partii.lopphetk)) AS "keskm. kestvus" FROM partii JOIN turniir ON partii.turniir = turniir.id GROUP BY turniir.nimi


UPDATE mina SET viimati=CURRENT TIMESTAMP;
SELECT turniir.nimi, AVG(DATEDIFF(minute,partii.algushetk,partii.lopphetk)) AS "keskm. kestvus" FROM partii JOIN turniir ON partii.turniir = turniir.id GROUP BY turniir.nimi

CREATE VIEW v_turniiripartii(turniir_nimi,partii_id,partii_algus,partii_lopp) AS
SELECT turniir.nimi, partii.id, partii.algushetk,partii.lopphetk FROM partii
JOIN turniir ON turniir.id=partii.turniir;
CREATE VIEW v_klubipartiikogus(klubi_nimi,partiisid) AS
SELECT klubi.nimi, COUNT(*) FROM klubi 
JOIN isik ON isik.klubi=klubi.id JOIN partii ON partii.valge=isik.id OR partii.must=isik.id GROUP BY klubi.nimi;

CREATE VIEW v_punkt(partii,turniir,mangija,varv,punkt) AS
SELECT partii.id,turniir.id,partii.valge,'V',CASE partii.valge_tulemus 
                WHEN 2 THEN 1.0
                WHEN 1 THEN 0.5
                ELSE 0.0
            END FROM partii JOIN turniir WHERE turniir.id=partii.turniir UNION
SELECT partii.id,turniir.id,partii.must,'M',CASE partii.musta_tulemus 
                WHEN 2 THEN 1.0
                WHEN 1 THEN 0.5
                ELSE 0.0
            END FROM partii JOIN turniir WHERE turniir.id=partii.turniir;
CREATE VIEW v_mangija (klubi_nimi,
    klubi_id, isik_nimi, isik_id) AS SELECT
    klubi.nimi, klubi.id, isik.perenimi || ', ' ||
    isik.eesnimi, isik.id FROM isik JOIN klubi ON
    isik.klubi = klubi.id;
CREATE VIEW v_edetabel(mangija,turniir,punkte) AS
SELECT v_mangija.isik_nimi,v_punkt.turniir,SUM(v_punkt.punkt) FROM v_punkt
JOIN v_mangija ON v_mangija.isik_id=v_punkt.mangija GROUP BY v_mangija.isik_nimi,v_punkt.turniir;
SELECT mangija,punkte FROM v_edetabel WHERE turniir=41 ORDER BY punkte DESC;
UPDATE mina SET viimati=CURRENT TIMESTAMP;
CREATE FUNCTION f_klubisuurus(k_id INTEGER)
RETURNS INTEGER NOT DETERMINISTIC
BEGIN
    DECLARE arv INTEGER;
    SELECT COUNT(*) INTO arv FROM isik WHERE klubi=k_id;
    RETURN ARV;
END;
CREATE FUNCTION f_nimi(i_id INTEGER)
RETURNS VARCHAR(100) NOT DETERMINISTIC
BEGIN
    DECLARE nimi VARCHAR(100);
    SELECT perenimi || ', ' || eesnimi INTO nimi FROM isik WHERE id=i_id;
    RETURN nimi;
END;

CREATE FUNCTION f_mangijakoormus(i_id INTEGER)
RETURNS INTEGER NOT DETERMINISTIC
BEGIN
    DECLARE arv INTEGER;
    SELECT COUNT(*) INTO arv FROM partii JOIN isik ON partii.valge=isik.id OR partii.must=isik.id
    WHERE isik.id=i_id;
    RETURN arv;
END;

CREATE PROCEDURE sp_uus_isik(IN i_eesnimi VARCHAR(50), IN i_perenimi VARCHAR(50), IN i_id INTEGER, OUT o_id INTEGER)
BEGIN
DECLARE l_id INTEGER;
INSERT INTO isik(eesnimi,perenimi,klubi)
VALUES(i_eesnimi,i_perenimi,i_id);
SELECT @@identity INTO l_id;
SET o_id=l_id;
END;

CREATE PROCEDURE sp_infopump()
RESULT("klubi" VARCHAR(50),"arv" INTEGER)
BEGIN
    (SELECT nimi,f_klubisuurus(id) FROM klubi ORDER BY nimi ASC) 
    UNION 
    (SELECT turniir.nimi,COUNT(*) FROM partii JOIN turniir ON turniir.id=partii.turniir GROUP BY turniir.nimi ORDER BY turniir.nimi ASC) 
    UNION 
    (SELECT f_nimi(id),f_mangijakoormus(id) FROM isik ORDER BY 1);
END;

CREATE PROCEDURE sp_top10(IN t_id INTEGER)
RESULT("Mngija" VARCHAR(100))
BEGIN
SELECT TOP 10 mangija FROM v_edetabel WHERE TURNIIR=t_id ORDER BY punkte;
END;
CREATE INDEX ix_algus ON turniir (alguskuupaev);
CREATE INDEX ix_tulemus ON partii (valge_tulemus DESC,musta_tulemus DESC);
CREATE TABLE Asula (
id INTEGER NOT NULL DEFAULT AUTOINCREMENT PRIMARY KEY,
nimi VARCHAR(100) NOT NULL,
UNIQUE(nimi)
);
INSERT INTO Asula(nimi) (SELECT toimumiskoht FROM turniir) UNION (SELECT aadress FROM klubi);
ALTER TABLE klubi ADD Asula INTEGER;
UPDATE klubi SET Asula = (Select id FROM Asula WHERE Asula.nimi = klubi.aadress);

ALTER TABLE klubi ADD CONSTRAINT fk_klubi_2_asula FOREIGN KEY (Asula) REFERENCES Asula(id) ON DELETE RESTRICT ON UPDATE CASCADE;
SELECT klubi.aadress, Asula.nimi FROM klubi JOIN Asula on klubi.Asula = Asula.id;
ALTER TABLE turniir ADD Asula INTEGER;
UPDATE turniir SET Asula=(SELECT id FROM Asula WHERE turniir.toimumiskoht=Asula.nimi);
ALTER TABLE turniir ADD CONSTRAINT fk_tuniir_2_asula FOREIGN KEY(Asula) REFERENCES Asula(id) ON DELETE RESTRICT ON UPDATE CASCADE;
SELECT turniir.toimumiskoht, Asula.nimi FROM turniir JOIN Asula ON turniir.Asula=Asula.id;
CREATE VIEW v_asulaklubisid(asula_id, asula_nimi, klubisid) AS
SELECT Asula.id, Asula.nimi, COUNT(klubi.id) FROM Asula JOIN klubi ON klubi.Asula=Asula.id GROUP BY Asula.id,Asula.nimi;
CREATE VIEW v_asulasuurus(asula_id, asula_nimi, mangijaid) AS
SELECT Asula.id, Asula.nimi, COUNT(isik.id) FROM Asula LEFT JOIN klubi ON klubi.Asula=Asula.id LEFT JOIN isik ON isik.klubi=klubi.id
GROUP BY Asula.id, Asula.nimi;
CREATE PROCEDURE sp_kustuta_klubi(IN i_nimi VARCHAR(50))
BEGIN
DELETE FROM klubi WHERE nimi=i_nimi;
END;
CREATE TRIGGER tg_kustuta_klubi AFTER
DELETE ON klubi
REFERENCING OLD as vana
FOR EACH ROW
WHEN (NOT EXISTS((SELECT Asula FROM klubi WHERE Asula=vana.Asula) UNION (SELECT Asula FROM turniir WHERE turniir.Asula=vana.Asula)))
BEGIN
DELETE FROM Asula WHERE id=vana.Asula;
END;
CREATE TRIGGER tg_lisa_klubi AFTER
INSERT ON klubi
REFERENCING NEW as uus
FOR EACH ROW
WHEN (NOT EXISTS(SELECT * FROM Asula WHERE Asula.nimi=uus.aadress))
BEGIN
  DECLARE l_id INTEGER;
  INSERT INTO Asula(nimi) VALUES(uus.aadress);
  SELECT @@identity INTO l_id;
  UPDATE klubi SET Asula = l_id WHERE
    id = uus.id;
END;
INSERT INTO klubi(nimi,aadress) VALUES('Kiire Aju','Viljandi');
INSERT INTO klubi(nimi,aadress) VALUES('Kambja Kibe','Kambja');
SELECT * FROM Asula;
call sp_kustuta_klubi('Kiire Aju');
call sp_kustuta_klubi('Kambja Kibe');
SELECT * FROM Asula;
INSERT INTO klubi(nimi,aadress) VALUES('SQL klubi','Tartu');
INSERT INTO isik(eesnimi,perenimi) VALUES('Signe','Adari');
UPDATE isik SET klubi=(SELECT id FROM klubi WHERE nimi='SQL klubi') WHERE eesnimi='Signe' AND perenimi='Adari';
DELETE FROM klubi WHERE klubi.nimi='SQL klubi';
-- Could not execute statement.
-- Primary key for row in table 'klubi' is referenced by foreign key
-- 'fk_isik_2_klubi' in table 'isik'
-- SQLCODE=-198, ODBC 3 State="23000"
-- Line 1, column 1
CREATE TRIGGER tg_kustuta_klubi_isikutega BEFORE
DELETE ON klubi
REFERENCING OLD as vana
FOR EACH ROW
BEGIN
DELETE FROM isik WHERE isik.klubi=vana.id;
END;
call sp_kustuta_klubi('Laudnikud');
-- Could not execute statement.
-- Primary key for row in table 'isik' is referenced by foreign key
-- 'fk_partii_2_isik_must' in table 'partii'
-- SQLCODE=-198, ODBC 3 State="23000"
-- Line 1, column 1
call sp_kustuta_klubi('SQL klubi');
INSERT INTO Mina
(eesnimi, perenimi, sugu, synnipaev)
VALUES ('Juku', 'Mets', 'Mees', '1980-02-04');
UPDATE Mina SET eesnimi='Signe',perenimi='Adari',synnipaev='1988-02-03';
CREATE VIEW V_1 AS SELECT isik.eesnimi,isik.perenimi FROM isik JOIN klubi ON isik.klubi=klubi.id WHERE klubi.nimi = 'Laudnikud' ORDER BY isik.eesnimi ASC, isik.perenimi ASC;
CREATE VIEW V_2 AS SELECT COUNT(*) FROM isik JOIN klubi ON isik.klubi=klubi.id WHERE klubi.nimi = 'Laudnikud';
CREATE VIEW V_3 AS SELECT isik.perenimi FROM isik JOIN klubi ON isik.klubi=klubi.id WHERE klubi.nimi LIKE 'V%' AND isik.eesnimi LIKE 'M%';
CREATE VIEW V_4 AS SELECT MIN(algushetk) FROM partii;
CREATE VIEW V_6 AS SELECT isik.eesnimi,isik.perenimi FROM partii JOIN isik ON partii.valge=isik.id WHERE partii.valge_tulemus=2;
CREATE VIEW V_7 AS SELECT isik.perenimi FROM isik GROUP BY isik.perenimi HAVING count(*)>1;
CREATE VIEW V_8 AS SELECT klubi.nimi FROM klubi KEY JOIN isik GROUP BY klubi.nimi HAVING count(*)<4;
CREATE VIEW V_9 AS SELECT COUNT(*) FROM partii JOIN isik ON partii.must=isik.id WHERE isik.eesnimi = 'Arvo';
CREATE VIEW V_10 AS SELECT turniir.nimi, COUNT(*) FROM partii JOIN isik ON partii.must=isik.id JOIN turniir ON partii.turniir=turniir.id WHERE isik.eesnimi = 'Arvo' GROUP BY turniir.nimi;
CREATE VIEW V_11 AS SELECT sum(CASE partii.valge_tulemus 
                WHEN 2 THEN 1
                WHEN 1 THEN 0.5
            END) AS Punktid FROM partii JOIN isik ON partii.valge=isik.id WHERE isik.eesnimi = 'Maria';
CREATE VIEW V_12 AS SELECT turniir.nimi, AVG(DATEDIFF(minute,partii.algushetk,partii.lopphetk)) AS "keskm. kestvus" FROM partii JOIN turniir ON partii.turniir = turniir.id GROUP BY turniir.nimi
CREATE VIEW V_5 AS SELECT f_nimi(valge.id),f_nimi(must.id) FROM partii JOIN isik AS valge ON partii.valge=valge.id JOIN isik AS must ON partii.must=must.id WHERE MONTH(partii.algushetk) = '03' AND HOUR(partii.algushetk) BETWEEN '09' AND '10';
UPDATE Mina SET Viimati=CURRENT TIMESTAMP;

