module Korg where


import Data.List
import System.IO
import System.IO.Error
import Rec


geom a q
  = iterate (* q) a

fibs1
  = [fst p | p <- iterate (\ (a , b) -> (b , a + b)) (0 , 1)]

pasDiag
  = iterate (tail . scanl (+) 0) (repeat 1)

osalistid1 (x : xs)
  = let
      pool
        = osalistid1 xs
    in
    map (x :) pool ++ pool
osalistid1 _
  = [[]]

suurSumma n
  | n >= 0
    = foldl (\ a i -> a + i ^ 4) 0 [1 .. n]
  | otherwise
    = error "suurSumma: neg. liidetavate arv"

osalistid2 (x : xs)
  = let
      pool
        = osalistid2 xs
    in
    foldr (\ as ass -> (x : as) : ass) pool pool
osalistid2 _
  = [[]]

suuredSummad
  = scanl (\ a i -> a + i ^ 4) 0 [1 .. ]

fibs4
  = 0 : scanl (+) 1 fibs4

lugemine
  = do
      putStr "Anna loetava faili nimi. "
      nimi <- getLine
      sisu <- readFile nimi
      putStrLn ("Faili " ++ nimi ++ " sisu:")
      putStrLn sisu
      putStrLn "(Lopp.)"

lugemineE1
  = lugemine `catch`
    const (putStrLn "Lugemisel tekkis erind!")

puunis e
  | isDoesNotExistError e
    = putStrLn "Pole faili!"
  | isPermissionError e
    = putStrLn "Pole faili lugemisoigust!"
  | otherwise
    = putStrLn "Tekkis tundmatu erind!"

lugemineE2
  = lugemine `catch` puunis

-- Def

loenda1 p xs
  = length (filter p xs)

nullideArv5 xs
  = loenda1 (0 ==) xs

loendaElem1 x xs
  = loenda1 (x ==) xs

taida f
  = do
      hSetBuffering stdin NoBuffering
      hSetBuffering stdout NoBuffering
      hSetEcho stdout False
      interact f
      hSetEcho stdout True

kaja
  = taida id

loenda2 p (x : xs)
  = let 
      ulejaanu
        = loenda2 p xs
    in
    if p x
      then 1 + ulejaanu
      else ulejaanu
loenda2 _ _
  = 0

loenda3 p xs
  = let
      arv n (z : zs)
        = arv (if p z then n + 1 else n) zs
      arv n _
        = n
    in
    arv 0 xs

map21 f g (x : xs)
  = f x : map21 g f xs
map21 _ _ _
  = []

map22 f g xs
  = zipWith ($) (cycle [f, g]) xs

map23 f g xs
  = zipWith id (cycle [f, g]) xs


-- Argumendivaba stiil

nullideArv2
  = loenda1 (0 ==)

loendaElem2 x
  = loenda1 (x ==)

sqr1 x
  = (*) x x
sqr2 sin
  = (*) sin sin

libabottom x
  = undefined x

jarjestaKiir3, jarjestaKiir4
  :: (Ord a)
  => [a] -> [a]
jarjestaKiir3
  = let
      kiir (x : xs) as
        = let
            (us , vs)
              = kaheksLahuta2 x xs
          in
          kiir us (x : kiir vs as)
      kiir _        as
        = as
    in
    flip kiir []

jarjestaKiir4
  = let
      kiir (x : xs)
        = let
            (us , vs)
              = kaheksLahuta2 x xs
          in
          kiir us . (x :) . kiir vs
      kiir _
        = id
    in
    flip kiir []

loenda4 p
  = let
      op x ulejaanu
        = if p x
            then 1 + ulejaanu
            else ulejaanu
      e = 0
    in
    foldr op e

loenda5 p
  = let
      op n z
        = if p z
            then n + 1
            else n
      e = 0
    in
    foldl op e

osalistid3
  = foldr (\ x pool -> foldr ((:) . (x :)) pool pool) [[]]


-- Universaalne rekursioon

p = (0 ==)

nullideArv6 (x : xs)
  = let
      ulejaanu
        = nullideArv6 xs
    in
    if p x
      then 1 + ulejaanu
      else ulejaanu
nullideArv6 _
  = 0

zs
  = (0 :) zs

geom2 a q
  = let
      abstr gs
        = a : [x * q | x <- gs]
      gs
        = abstr gs
    in
    gs

suurSummaAbstr suurSumma1 n
  = case compare n 0 of
      GT
        -> suurSumma1 (n - 1) + n ^ 4
      EQ
        -> 0
      _
        -> error "suurSumma1: negatiivne argument"

suurSumma4
  = suurSummaAbstr suurSumma4

fix1 f
  = f (fix1 f)

geom3 a q
  = let
      abstr gs
        = a : [x * q | x <- gs]
    in
    fix1 abstr

suurSumma5
  = fix1 suurSummaAbstr

fix2 f
  = let
      x = f x
    in
    x

geom4 a q
  = let
      abstr gs
        = a : [x * q | x <- gs]
    in
    fix2 abstr

suurSumma6
  = fix2 suurSummaAbstr

