module Laiend where


class (Enum a, Bounded a) => Fin a where

  koik
    :: [a]

  koik
    = [minBound .. maxBound]


instance (Show a, Show b, Fin a) => Show (a -> b) where

  showsPrec n f as
    = let
        lisa k
          = (++) ", " .
            showsPrec n k . 
            (++) " -> " .
            showsPrec n (f k)
        _ : _ : s
          = foldr lisa ('}' : as) koik
      in
      '{' : s


data Kahend a
  = Tuhi
  | Tipp a (Kahend a) (Kahend a)
  deriving (Show)

kahendSuurus
  :: Kahend a -> Int
kahendSuurus (Tipp _ ut vt)
  = 1 + kahendSuurus ut + kahendSuurus vt
kahendSuurus _
  = 0

kahendSumma
  :: (Num a)
  => Kahend a -> a
kahenndSumma (Tipp x ut vt)
  = x + kahendSumma ut + kahendSumma vt
kahendSumma _
  = 0

taielik
  :: Int -> Kahend Int
taielik n
  = case compare n 0 of
      GT
        -> let
             t = taielik (n - 1)
           in
           Tipp n t t
      EQ
        -> Tuhi
      _
        -> error "taielik: neg. argument"


data Mitmeraja a
  = Puu a (Mets a)
  deriving (Show)
type Mets a
  = [Mitmeraja a]

mitmerajaSumma
  :: (Num a)
  => Mitmeraja a -> a
mitmerajaSumma (Puu x rs)
  = x + sum (map mitmerajaSumma rs)


data FPuu a b
  = FTuhi
  | FTipp a (FMets a b)
  deriving (Show)
type FMets a b
  = b -> FPuu a b

data ListAlam
  = Saba
  deriving (Show, Enum, Bounded)

data KahendAlam
  = VasakHaru
  | ParemHaru
  deriving (Show, Enum, Bounded)

instance Fin ListAlam where

instance Fin KahendAlam where


type FList a
  = FPuu a ListAlam
type FKahend a
  = FPuu a KahendAlam

listFKujule
  :: [a] -> FList a
listFKujule (x : xs)
  = FTipp x (\ ~Saba -> listFKujule xs)
listFKujule _
  = FTuhi

kahendFKujule
  :: Kahend a -> FKahend a
kahendFKujule (Tipp x ut vt)
  = let
      harud VasakHaru
        = kahendFKujule ut
      harud ParemHaru
        = kahendFKujule vt
    in
    FTipp x harud
kahendFKujule _
  = FTuhi


data Kahend2 a
  = Tuhi2
  | Tipp2
    {
      juur :: a,
      vasak :: Kahend2 a,
      parem :: Kahend2 a
    }
  deriving (Show)

newtype Juur a
  = Juur a
  deriving (Show)
newtype Vasak a
  = Vasak a
  deriving (Show)
newtype Parem a
  = Parem a
  deriving (Show)

data Kahend3 a
  = Tuhi3
  | Tipp3 (Juur a) (Vasak (Kahend3 a)) (Parem (Kahend3 a))
  deriving (Show)

naide
  :: Kahend3 Int
naide
  = Tipp3
    ( Juur $ 5 )
    (
      Vasak $
      Tipp3 ( Juur $ 2 ) ( Vasak $ Tuhi3 )
      (
        Parem $
        Tipp3 ( Juur $ 3 ) ( Vasak $ Tuhi3 ) ( Parem $ Tuhi3 )
      )
    )
    (
      Parem $
      Tipp3 ( Juur $ 7 ) ( Vasak $ Tuhi3 ) ( Parem $ Tuhi3 )
    )


newtype Naljane a
  = Naljane (a -> Naljane a)

amps
  :: Naljane a -> a -> Naljane a
Naljane f `amps` x
  = f x

eritiNaljane
  = Naljane (const eritiNaljane)

instance Show (Naljane a) where

  show _
    = "Anna ampsu! Tahan veel!"


newtype Fix a
  = Fix (Fix a -> a)


rak
  :: Fix a -> Fix a -> a
Fix f `rak` x
  = f x


eneserak
  :: Fix a -> a
eneserak f
  = f `rak` f

tsukkel
  = eneserak (Fix eneserak)

impr, impr2
  :: Fix Bool -> Bool
impr p
  = not (eneserak p)

russelliParadoks
  = impr (Fix impr)

impr2
  = not . eneserak

fix3 f
  = let
      h = f . eneserak
    in
    h (Fix h)


zs
  = fix3 (0 :)

suurSummaAbstr suurSumma1 n
  = case compare n 0 of
      GT
        -> suurSumma1 (n - 1) + n ^ 4
      EQ
        -> 0
      _
        -> error "suurSumma1: negatiivne argument"

suurSumma
  = fix3 suurSummaAbstr

geom a q
  = let
      abstr gs
        = a : [x * q | x <- gs]
    in
    fix3 abstr
