module Rec where


-- Akumulaatorid

kaheksLahuta1 x (z : zs)
  = let
      (us , vs)
        = kaheksLahuta1 x zs
    in
    if z < x
      then (z : us , vs)
      else (us , z : vs)
kaheksLahuta1 _ _
  = ([] , [])

kaheksLahuta2 x xs
  = let
      lahuta as bs (z : zs)
        = if z < x
            then lahuta (z : as) bs zs
            else lahuta as (z : bs) zs
      lahuta as bs _
        = (reverse as , reverse bs)
    in
    lahuta [] [] xs


nullideArv1 (x : xs)
  = let
      sabal
        = nullideArv1 xs
    in
    if x == 0
      then 1 + sabal
      else sabal
nullideArv1 _
  = 0

nullideArv2 xs
  = let
      arv n (z : zs)
        = arv (if z == 0 then n + 1 else n) zs
      arv n _
        = n
    in
    arv 0 xs

nullideArv3 xs
  = let
      arv n (z : zs)
        = ($!) arv (if z == 0 then n + 1 else n) zs
      arv n _
        = n
    in
    arv 0 xs


tagurpidi1 (x : xs)
  = tagurpidi1 xs ++ [x]
tagurpidi1 _
  = []

tagurpidi2 xs
  = let
      tagur (x : xs) as
        = tagur xs (x : as)
      tagur _        as
        = as
    in
    tagur xs []


suuredSummad2
  = let
      summad a i
        = a : summad (a + i ^ 4) (i + 1)
    in
    summad 0 1

suuredSummad3
  = let
      summad a i
        = a : ($!) summad (a + i ^ 4) (i + 1)
    in
    summad 0 1

fibs2
  = let
      fibs a b
        = a : fibs b (a + b)
    in
    fibs 0 1

fibs3
  = let
      fibs a b
        = a : ($!) fibs b (a + b)
    in
    fibs 0 1


kordusteta1 (x : xs)
  = not (elem x xs) && kordusteta1 xs
kordusteta1 _
  = True

kordusteta2 xs
  = let
      abi as (z : zs)
        = not (elem z as) && abi (z : as) zs
      abi _  _
        = True
    in
    abi [] xs


suurSumma1 n
  = case compare n 0 of
      GT
        -> suurSumma1 (n - 1) + n ^ 4
      EQ
        -> 0
      _
        -> error "suurSumma1: negatiivne argument"

suurSumma2 n
  | n >= 0
    = let
        summa a i
          | i <= n
            = summa (a + i ^ 4) (i + 1)
          | otherwise
            = a
      in
      summa 0 1
  | otherwise
    = error "suurSumma2: negatiivne argument"

suurSumma3 n
  | n >= 0
    = let
        summa a i
          | i <= n
            = ($!) summa (a + i ^ 4) (i + 1)
          | otherwise
            = a
      in
      summa 0 1
  | otherwise
    = error "suurSumma3: negatiivne argument"


-- "Jaga ja valitse"

hanoi1 n
  | n >= 0
    = let
        hanoi 0 _ _ _
          = []
        hanoi n x y z
          = let
              r = n - 1
            in
            hanoi r x z y ++ [x, y] : hanoi r z y x
      in
      hanoi n 'A' 'B' 'C'
  | otherwise
    = error "hanoi1: negatiivne argument"

hanoi2 n
  | n >= 0
    = let
        hanoi 0 _ _ _ as
          = as
        hanoi n x y z as
          = let
              r = n - 1
            in
            hanoi r x z y ([x, y] : hanoi r z y x as)
      in
      hanoi n 'A' 'B' 'C' []
  | otherwise
    = error "hanoi2: negatiivne argument"

jarjestaKiir xs
  = let
      kiir (x : xs) as
        = let
            (us , vs)
              = kaheksLahuta2 x xs
          in
          kiir us (x : kiir vs as)
      kiir _        as
        = as
    in
    kiir xs []

suuruseltNr n xs
  | 0 <= n && n < length xs
    = jarjestaKiir xs !! n
  | otherwise
    = error "suuruseltNr: mootmetest valjas"


-- Pimemeetod

poim
  :: (Ord a)
  => [a] -> [a] -> [a]
poim xs@ (a : as) ys@ (b : bs)
  | a <= b
    = a : poim as ys
  | otherwise
    = b : poim xs bs
poim xs           []
  = xs
poim _            ys
  = ys

jupid xs
  = [[x] | x <- xs]

jarjestaPoim []
  = []
jarjestaPoim xs
  = poimiPuu (jupid xs)

poimiTase (xs : ys : yss)
  = poim xs ys : poimiTase yss
poimiTase xss
  = xss

poimiPuu xss@ (_ : _ : _)
  = poimiPuu (poimiTase xss)
poimiPuu [xs]
  = xs


eraldaSegment (x : xs@ ~(y : _))
  | null xs || x > y
    = ([x] , xs)
  | otherwise
    = let
        (us , vs)
          = eraldaSegment xs
      in
      (x : us , vs)
eraldaSegment _
  = ([] , [])

segmendid
  :: (Ord a)
  => [a] -> [[a]]
segmendid xs
  | null xs
    = []
  | otherwise
    = let
        (us , vs)
          = eraldaSegment xs
      in
      us : segmendid vs


-- Dnaamiline programmeerimine

aste1 a n
  = case compare n 0 of
      GT
        -> a * aste1 a (n - 1)
      EQ
        -> 1
      _
        -> 1 / aste1 a (-n)

aste2 a n
  = case compare n 0 of
      GT
        -> let
             (q , r)
               = n `divMod` 2
             x = aste2 a q
           in
           if r == 0
             then x * x
             else a * x * x
      EQ
        -> 1
      _
        -> 1 / aste2 a (-n)

aste15 a n
  = case compare n 0 of
      GT
        -> let
             (q , r)
               = n `divMod` 2
           in
           if r == 0
             then aste15 a q * aste15 a q
             else a * aste15 a q * aste15 a q
      EQ
        -> 1
      _
        -> 1 / aste15 a (-n)

fib 0 = 0
fib 1 = 1
fib n 
  = fib (n - 1) + fib (n - 2)

kahesummad' (x : xs)
  = let
      summad x (y : ys)
        = x + y : summad y ys
      summad x _
        = [x]
    in
    x : summad x xs

pasRead
  = let
      bss
        = [1] : [kahesummad' bs | bs <- bss]
    in
    bss

osasummad (x : y : ys)
  = x : osasummad (x + y : ys)

pasDiag
  = let
      bss
        = repeat 1 : [osasummad bs | bs <- bss]
    in
    bss

bin3 n k
  | n >= 0 && k >= 0
    = if n >= k
        then pasRead !! n !! k
        else 0
  | otherwise
    = error "bin: negatiivne argument"

bin4 n k
  | n >= 0 && k >= 0
    = if n >= k
        then pasDiag !! (n - k) !! k
        else 0
  | otherwise
    = error "bin: negatiivne argument"
